$.fn.jqDatePicker = function(){
	this.each(function(i, el){
		var _$Context = $(el), _$DatePickerInput, _$DayInput, _$MonthInput, _$YearInput, init, _bindEvents, _setDate, _applyJDatePicker;
		
		init = function(options){
			_$DayInput = $('.dateDay input, .dateDay select', _$Context);
			_$MonthInput = $('.dateMonth select', _$Context);
			_$YearInput = $('.dateYear select, .dateYear input', _$Context);
			_$DatePickerInput = $('<input type="hidden" />').appendTo(_$Context);
			_setDate();
			_bindEvents();
		};
		
		_bindEvents = function(){
			_applyJDatePicker(_$DatePickerInput);
			_$DayInput.bind('blur keyup change', _setDate);
			_$MonthInput.bind('change', _setDate);
			_$YearInput.bind('change', _setDate);
		};
		
		_setDate = function(){
		    var day = $.trim(_$DayInput.val()), month = $.trim(_$MonthInput.val()), year = $.trim(_$YearInput.val());
		    if(!day || !month || !year)
		    	return;
		    
			_$DatePickerInput.val(day + "/" + month + "/" + year);
		};
		
		_applyJDatePicker = function($Target){
			$Target.datepicker({
				showOn: "button",
		        buttonImage: (contextRoot || "") + "images/caloff.gif",
		        buttonImageOnly: true,
		        minDate: "01/01/" + (_$YearInput.find('option').eq(1).attr('value') || 1900), 
		        //maxDate: "31/12/" + dDate.getFullYear(), 
		        dateFormat : 'd/m/yy',
		        onSelect : function(date){
		        	var aDate = date.split('/');
	    			_$DayInput.val(aDate[0]);
	    			_$MonthInput.val(aDate[1]);
	    			_$YearInput.val(aDate[2]);
		        }
			});
		};
		
		init();
	});
}

//Now in utils.js
//$(function(){
//	$('.jq-date').jqDatePicker();
//})
